import { Link, useLocation } from 'react-router-dom'
import { Tent } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app-wrapper-nature">
      <header className="header-nature">
        <div className="container">
          <div className="header-content-nature">
            <Link to="/" className="logo-nature">
              <div className="logo-icon-wrapper-nature">
                <Tent className="logo-icon-nature" size={32} />
              </div>
              <span className="logo-text-nature">CAMPGEAR</span>
            </Link>
            <nav className="nav-nature">
              <Link 
                to="/" 
                className={`nav-link-nature ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои аренды
              </Link>
              <Link 
                to="/rent" 
                className={`nav-link-nature ${location.pathname === '/rent' ? 'active' : ''}`}
              >
                Арендовать
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main-content-nature">
        {children}
      </main>

      <Footer />
    </div>
  )
}

export default Layout

